<?php

// =========================================================
// CONFIG
// =========================================================
$botToken = getenv('BOT_TOKEN') ?: '8383398973:AAHrIFCbknPAq59kAg4HarwtHGy4zNgcrm0';
$chatId   = "8170892762";
$apiURL   = "https://api.telegram.org/bot{$botToken}/sendMessage";

$stateFile = __DIR__ . "/state.json";

// =========================================================
// INIT STATE (IF NOT EXIST)
// =========================================================
if (!file_exists($stateFile)) {
    file_put_contents($stateFile, json_encode([
        "last_pk"         => 0,
        "last_views"      => -1,
        "limit"           => 0,
        "limit_triggered" => false,
        "paused"          => false
    ], JSON_PRETTY_PRINT));
}

$state = json_decode(file_get_contents($stateFile), true);

$lastPK     = $state["last_pk"];
$lastViews  = $state["last_views"];
$limit      = $state["limit"];
$triggered  = $state["limit_triggered"];
$paused     = $state["paused"];

// =========================================================
// STOP IF PAUSED
// =========================================================
if ($paused) exit("PAUSED\n");

// =========================================================
// SEND TELEGRAM MESSAGE
// =========================================================
function sendTG($apiURL, $chatId, $msg) {
    file_get_contents($apiURL . '?' . http_build_query([
        "chat_id" => $chatId,
        "text"    => $msg,
        "parse_mode" => "Markdown",
        "disable_web_page_preview" => true
    ]));
}

// =========================================================
// FETCH REELS FROM API (NEW FORMAT)
// =========================================================
function fetchReelsFixedUser() {

    $url = "https://black-credit-4731.try-sangnt.workers.dev/";
    $payload = json_encode(["maxId" => ""]);

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => $payload,
        CURLOPT_HTTPHEADER     => ["Content-Type: application/json"]
    ]);

    $resp = curl_exec($ch);
    curl_close($ch);

    $json = json_decode($resp, true);

    return $json["reels"] ?? [];
}

// =========================================================
// MAIN PROCESS
// =========================================================
$edges = fetchReelsFixedUser();

if (!$edges) {
    sendTG($apiURL, $chatId, "
    📌 Lệnh điều khiển tool
    /run – Bật tool
    /stop – Tạm dừng tool
    /setlimit VIEW – Dừng khi view vượt mức
    /posted – Chạy lại sau khi đạt limit
    /state – Xem trạng thái
    /help – Hướng dẫn");
    sendTG($apiURL, $chatId, "❌ API lỗi hoặc không có reels.");

    exit("NO REELS\n");
}

// Username
$username = $edges[0]["node"]["media"]["user"]["id"] ?? "unknown";

// Tìm reel mới nhất
$newestPK = -1;
$newestMedia = null;

foreach ($edges as $item) {
    $m = $item["node"]["media"] ?? null;
    if (!$m) continue;

    // Bỏ pinned
    if (!empty($m["clips_tab_pinned_user_ids"])) continue;

    $pk = intval($m["pk"]);

    if ($pk > $newestPK) {
        $newestPK    = $pk;
        $newestMedia = $m;
    }
}

if (!$newestMedia) {
    sendTG($apiURL, $chatId, "
    📌 Lệnh điều khiển tool
    /run – Bật tool
    /stop – Tạm dừng tool
    /setlimit VIEW – Dừng khi view vượt mức
    /posted – Chạy lại sau khi đạt limit
    /state – Xem trạng thái
    /help – Hướng dẫn");
    sendTG($apiURL, $chatId, "❌ Không tìm thấy media hợp lệ.");

    exit("NO MEDIA\n");
}

// =========================================================
// CHECK NEW REEL
// =========================================================
$isNewReel = false;

if ($newestPK > $lastPK) {

    $isNewReel = true;

    $code = $newestMedia["code"];
    $url  = "https://www.instagram.com/reel/$code/";
    sendTG($apiURL, $chatId, "
    📌 Lệnh điều khiển tool
    /run – Bật tool
    /stop – Tạm dừng tool
    /setlimit VIEW – Dừng khi view vượt mức
    /posted – Chạy lại sau khi đạt limit
    /state – Xem trạng thái
    /help – Hướng dẫn");
    sendTG($apiURL, $chatId, "🆕 *Reel mới!*\n▶️ $url");

    $state["last_pk"] = $newestPK;
}

// =========================================================
// ALWAYS UPDATE last_views FIRST
// =========================================================
$views = $newestMedia["play_count"] ?? 0;
$code  = $newestMedia["code"];
$url   = "https://www.instagram.com/reel/$code/";

$isViewChanged = ($views != $lastViews);

// luôn cập nhật last_views (dù có gửi notify hay không)
$state["last_views"] = $views;

// =========================================================
// CHECK LIMIT (AFTER UPDATING last_views)
// =========================================================
if ($limit > 0 && !$triggered && $views >= $limit) {

    sendTG(
        $apiURL,
        $chatId,
        "🔥 *Vượt $limit view!*\n"
        
        ."👁 View: *".number_format($views)."*\n▶️ $url\n\n"

        ."⏸ Tool đã dừng – gửi /posted để chạy lại"
    );
    sendTG(
        $apiURL,
        $chatId,
        "✅✅✅✅✅"
    );

    $state["paused"] = true;
    $state["limit_triggered"] = true;

    file_put_contents($stateFile, json_encode($state, JSON_PRETTY_PRINT));
    exit("LIMIT REACHED\n");
}

// =========================================================
// SAVE STATE
// =========================================================
file_put_contents($stateFile, json_encode($state, JSON_PRETTY_PRINT));

echo "DONE\n";
