<?php

// =========================================================
// CONFIG
// =========================================================
$botToken     = "8383398973:AAHrIFCbknPAq59kAg4HarwtHGy4zNgcrm0";
$adminChatId  = "8170892762";
$stateFile    = __DIR__ . "/state.json";

$apiURL = "https://api.telegram.org/bot$botToken/";


// =========================================================
// INIT STATE FILE
// =========================================================
if (!file_exists($stateFile)) {
    file_put_contents($stateFile, json_encode([
        "last_pk"         => 0,
        "last_views"      => -1,
        "limit"           => 0,
        "limit_triggered" => false,
        "paused"          => false
    ], JSON_PRETTY_PRINT));
}


// =========================================================
// LOAD / SAVE STATE
// =========================================================
function loadState($file) {
    return json_decode(file_get_contents($file), true);
}

function saveState($file, $state) {
    file_put_contents($file, json_encode($state, JSON_PRETTY_PRINT));
}


// =========================================================
// SEND TELEGRAM MESSAGE
// =========================================================
function sendMsg($chatId, $text) {
    global $apiURL;

    file_get_contents($apiURL . "sendMessage?" . http_build_query([
        "chat_id" => $chatId,
        "text"    => $text,
        "parse_mode" => "Markdown",
        "disable_web_page_preview" => true
    ]));
}


// =========================================================
// RECEIVE UPDATE
// =========================================================
$update = json_decode(file_get_contents("php://input"), true);
if (!$update) exit("NO UPDATE");

$msg  = trim($update["message"]["text"] ?? "");
$chat = $update["message"]["chat"]["id"] ?? "";

if ($chat != $adminChatId) {
    sendMsg($chat, "❌ Bạn không có quyền dùng bot này.");
    exit;
}

$state = loadState($stateFile);


// =========================================================
// COMMAND LIST
// =========================================================
function helpText() {
    return "📌 *Lệnh điều khiển tool*\n"
    ."/run – Bật tool\n"
    ."/stop – Tạm dừng tool\n"
    ."/setlimit VIEW – Dừng khi view vượt mức\n"
    ."/posted – Chạy lại sau khi đạt limit\n"
    ."/state – Xem trạng thái\n"
    ."/help – Hướng dẫn";
}


// =========================================================
// PROCESS COMMANDS
// =========================================================

// /start
if ($msg === "/start") {
    sendMsg($chat, "Xin chào!\n" . helpText());
    exit;
}

// /help
if ($msg === "/help") {
    sendMsg($chat, helpText());
    exit;
}

// /state
if ($msg === "/state") {

    $txt =
        "📊 *Trạng thái tool*\n"
        ."• Paused: " . ($state["paused"] ? "⏸ yes" : "▶️ no") . "\n"
        ."• Last PK: " . $state["last_pk"] . "\n"
        ."• Last Views: " . number_format($state["last_views"]) . "\n"
        ."• Limit: " . ($state["limit"] ?: "0 (off)") . "\n"
        ."• Limit Triggered: " . ($state["limit_triggered"] ? "🔥 yes" : "no");

    sendMsg($chat, $txt);
    exit;
}

// /stop
if ($msg === "/stop") {
    $state["paused"] = true;
    saveState($stateFile, $state);
    sendMsg($chat, "⏸ Tool đã *tạm dừng*.");
    exit;
}

// /run
// /run
if ($msg === "/run") {

    $state["paused"] = false;
    $state["limit_triggered"] = false;
    saveState($stateFile, $state);

    sendMsg($chat, "▶️ Tool đã *chạy lại*!\nPaused: no");

    exit;
}

// /setlimit
if (preg_match("/^\/setlimit (\d+)$/", $msg, $m)) {

    $limit = intval($m[1]);
    if ($limit <= 0) {
        sendMsg($chat, "❌ Limit không hợp lệ.");
        exit;
    }

    $state["limit"]           = $limit;
    $state["limit_triggered"] = false;

    saveState($stateFile, $state);

    sendMsg($chat, "🎯 Giới hạn view đã đặt thành *$limit*.");
    exit;
}

if ($msg === "/posted") {

    if (empty($state["limit"])) {
        sendMsg($chat, "❌ Chưa đặt limit. Dùng /setlimit VIEW.");
        exit;
    }

    $state["paused"] = false;
    $state["limit_triggered"] = false;

    saveState($stateFile, $state);

    sendMsg($chat, "🔄 Tool *chạy lại*. Limit hiện tại: *".$state["limit"]."*");
    exit;
}



//===========================================================
// DEFAULT
//===========================================================
sendMsg($chat, "❌ Lệnh không hợp lệ.\n\n" . helpText());
